"use client";
import { useState } from "react";
import Validation from "@/app/component/Validation";
import PUTMEScreeningFee from "../../component/PUTMEScreeningFee";
import PartApplicationFee from "../../component/PartApplicationFee";
import Link from "next/link";
import InputField from "@/app/component/InputField";
import SelectField from "@/app/component/SelectField";
import FileField from "@/app/component/FileField";

function Page() {
  const [activeTab, setActiveTab] = useState("fulltime");
  const [showFee, setShowFee] = useState(false);
  const [manualOLevel, setManualOLevel] = useState([]);
  const [formData, setFormData] = useState({
    fulltime: {
      first_name: "",
      last_name: "",
      middle_name: "",
      email: "",
      phone: "",
      DOB: "",
      gender: "",
      jamb_reg: "",
      jamb_result: "",
      o_level: "",
    },
    parttime: {
      first_name: "",
      last_name: "",
      middle_name: "",
      gender: "",
      DOB: "",
      state_of_origin: "",
      lga: "",
      phone: "",
      email: "",
      address: "",
      passport: "",
      o_level: "",
    },
  });

  const handleTabSwitch = (tab) => setActiveTab(tab);

  const handleChange = (e) => {
    const { name, value, files } = e.target;
    const tabData = formData[activeTab];

    if (name === "passport" || name === 'o_level' || (activeTab === "fulltime" && (name === "o_level" || name === "jamb_result"))) {
      const file = files[0];
      if (file) {
        setFormData({
          ...formData,
          [activeTab]: {
            ...tabData,
            [name]: file,
          },
        });
      }
    } else {
      setFormData({
        ...formData,
        [activeTab]: {
          ...tabData,
          [name]: value,
        },
      });
    }
  };

  const addOLevelField = () => {
    setManualOLevel([...manualOLevel, { subject: "", grade: "" }]);
  };

  const handleOLevelChange = (index, e) => {
    const { name, value } = e.target;
    const updatedOLevel = [...manualOLevel];
    updatedOLevel[index][name] = value;
    setManualOLevel(updatedOLevel);
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    setShowFee(!showFee);
  };

  return (
    <div className="bg-[#f3f3f3] flex justify-center min-h-screen">
      <div className="shadow-lg bg-orange-300 rounded-sm p-4 sm:p-7 m-4 sm:m-32 w-full max-w-screen-lg">
        {activeTab === "fulltime" && <h1 className="font-bold mb-5 text-2xl pt-3 text-center">Post UTME Screening Form</h1>}
        {activeTab === "parttime" && <h1 className="font-bold mb-5 text-2xl pt-3 text-center">Part Time Application Form</h1>}
        
        {!showFee && (
        <div className="flex gap-4 justify-center mb-6">
          <button
            className={`px-4 py-2 rounded ${activeTab === "fulltime" ? "bg-orange-400 text-white" : ""}`}
            onClick={() => handleTabSwitch("fulltime")}
          >
            Full-Time
          </button>
          <button
            className={`px-4 py-2 rounded ${activeTab === "parttime" ? "bg-orange-400 text-white" : ""}`}
            onClick={() => handleTabSwitch("parttime")}
          >
            Part-Time
          </button>
        </div>
      )}

        {!showFee ? (
          <form onSubmit={handleSubmit}>
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
              {/* Common Fields */}
              <InputField name="first_name" label="First Name" onChange={handleChange} />
              <InputField name="last_name" label="Last Name" onChange={handleChange} />
              <InputField name="middle_name" label="Middle Name" onChange={handleChange} />
              <InputField name="email" label="Email Address" type="email" onChange={handleChange} />
              <InputField name="phone" label="Phone Number" type="tel" onChange={handleChange} />
              <InputField name="DOB" label="Date of Birth" type="date" onChange={handleChange} />
              <SelectField name="gender" label="Gender" options={["male", "female", "other"]} onChange={handleChange} />
              <InputField name="course" label="Course" value='Broadcast Journalism' />
              <InputField name="college" label="College" value='Social Science' />

              {/* Full-Time Specific Fields */}
              {activeTab === "fulltime" && (
                  <>
                  <InputField name="jamb_reg" label="JAMB Registration Number" onChange={handleChange} />
                  <FileField name="jamb_result" label="Upload JAMB Result" onChange={handleChange} />
                  <FileField name="o_level" label="Upload O-Level Result" onChange={handleChange} />
                </>
              )}

              {/* Part-Time Specific Fields */}
              {activeTab === "parttime" && (
                  <span>
                  <InputField name="state_of_origin" label="State of Origin" onChange={handleChange} />
                  <InputField name="lga" label="LGA" onChange={handleChange} />
                  <InputField name="address" label="Address" onChange={handleChange} />
                  <FileField name="passport" label="Upload Passport" onChange={handleChange} />
                  <FileField name="o_level" label="Upload O-Level Result" onChange={handleChange} />

                  <div className="col-span-2 mt-5">
                    <h2 className="font-semibold">Manual O-Level Entry</h2>
                    {manualOLevel.map((field, index) => (
                      <div key={index} className="flex gap-2 mb-2">
                        <InputField
                          name="subject"
                          label="Subject"
                          value={field.subject}
                          onChange={(e) => handleOLevelChange(index, e)}
                        />
                        <InputField
                          name="grade"
                          label="Grade"
                          value={field.grade}
                          onChange={(e) => handleOLevelChange(index, e)}
                        />
                      </div>
                    ))}
                    <button
                      type="button"
                      className="bg-orange-400 text-white px-4 py-2 rounded mt-3"
                      onClick={addOLevelField}
                    >
                      Add Subject
                    </button>
                  </div>
                </span>
              )}
            </div>

            <div className="flex justify-center mt-10">
              <button type="submit" className="bg-orange-400 text-white px-10 py-2 rounded">
                Continue
              </button>
            </div>

            <div className="flex gap-2 w-full justify-end pt-3">
              <p className="font-medium">Already applied?</p>
              <Link href="/aspirant/nid/login" className="underline text-orange-500">
                Login here
              </Link>
            </div>
          </form>
        ) : (
        //   <PUTMEScreeningFee formData={formData[activeTab]} handleBack={() => setShowFee(false)} />
            activeTab === "fulltime" ? (
              <PUTMEScreeningFee formData={{...formData[activeTab], manual_o_level: manualOLevel}} handleBack={() => setShowFee(false)} />
            ) : (
            //   <PartApplicationFee formData={formData[activeTab]} handleBack={() => setShowFee(false)} />
              <PartApplicationFee formData={{...formData[activeTab], manual_o_level: manualOLevel}} handleBack={() => setShowFee(false)} />
            )
        )}
      </div>
    </div>
  );
}

export default Page;
